import pandas as pd   
from sklearn.preprocessing import LabelEncoder
import pickle
from decision_company import read_csv_file, avg, bind_dataframe

# Load the dataset  
credit_customers = read_csv_file("credit_customers.csv")  
  
# Analyze the relationships between variables  
credit_history_duration_relationship = avg(bind_dataframe(stable_employment, 'credit_history')['duration'])  
  
# Print the relationship   
print("\nRelationship between credit history and loan duration:\n", credit_history_duration_relationship)   
pickle.dump(credit_history_duration_relationship, open("./ref_result/credit_history_duration_relationship.pkl","wb"))

  